
  document.addEventListener('DOMContentLoaded', PWGen_Options_Init);

  var pwg_cfg = {};
      pwg_cfg.Options = {};      
  
    function PWGen_Options_Load() {
      browser.storage.local.get()
        .then(settings => {
        if (!settings.Options) {console.log ("Erster Aufruf der Optionen, Laden abgebrochen. Warte auf Usereingaben!"); return;}          // Optionen wurden noch nie gesetzt -> Abbruch!
        Object.keys(settings.Options).forEach(
        key => getID(key).value = settings.Options[key]
        );           // Einmal durchs Array bitte und die Daten in den Optionen einfgen...
      }, error => console.log(`Error: ${error}`));
    }
    
    function PWGen_Options_Init(){    
    PWGen_Options_Load();
    var i;
    var tablinks = document.getElementsByClassName("PWGen_tablinks");    
    for (i = 0; i < tablinks.length; i++) {                                                           // Listener fr die Options-Tabs
      getID(tablinks[i].id).addEventListener("click", function(e){PWGen_openTab(this.name, e)});
    }
    
    var i;
    var optionen = document.getElementsByClassName("PWGenOptionsInput");    
    for (i = 0; i < optionen.length; i++) {                                                           
      getID(optionen[i].id).addEventListener("change", function(e){
        var c;
        var defaultSettings = {};
            defaultSettings.Options = {};
        var inputs = document.getElementsByClassName("PWGenOptionsInput");                         // Listener fr die Optionsfelder
        for (c = 0; c < inputs.length; c++) {
          defaultSettings.Options[inputs[c].id] = getID(inputs[c].id).value;
        }
        browser.storage.local.set(defaultSettings)
        .then (() => setTimeout(() => setStatus(e.target.id), 500));
        PWGen_CheckAnsicht();
        e.preventDefault();
      });
    }

    
    var Adresse = window.location.href; 
    var Adresse_Parameter = new URL(Adresse);                
    var Adresse_Paramater_Ziel = Adresse_Parameter.searchParams.get("ziel");                                     // auf URL-Parameter checken...
    if (Adresse_Paramater_Ziel) {getID("PWGenOptions_Button"+Adresse_Paramater_Ziel).click();}                   // wenn URL-Parameter "Ziel" dann direkt laden
    else {getID("PWGenOptions_ButtonAllgemein").click();}
    
    var t = setTimeout(function(){
      PWGen_CheckAnsicht(); 
    }, 50);
  }
  
  function PWGen_openTab(tabName, event) {
    // Declare all variables
    var i, tabcontent, tablinks;

    // Get all elements with class="tabcontent" and hide them
    tabcontent = document.getElementsByClassName("PWGen_Tabcontent");
    for (i = 0; i < tabcontent.length; i++) {
        tabcontent[i].style.display = "none";
    }
    tabcontent = document.getElementsByClassName("PWGen_TabcontentSub");
    for (i = 0; i < tabcontent.length; i++) {
        tabcontent[i].style.display = "none";
    }
        

    // Get all elements with class="tablinks" and remove the class "active"
    tablinks = document.getElementsByClassName("PWGen_tablinks");
    for (i = 0; i < tablinks.length; i++) {
        tablinks[i].className = tablinks[i].className.replace(" active", "");        
    }

    // Show the current tab, and add an "active" class to the button that opened the tab
    getID("PWGenOptionsTabs"+event.target.innerHTML).style.display = "block";
    if (getID("PWGenOptionsTabs"+event.target.innerHTML+"Submenu")) {
      getID("PWGenOptionsTabs"+event.target.innerHTML+"Submenu").style.display = "block";
    }
    getID(event.target.id).classList.add("active");
}


  // Markeroptionen, Profioptionen etc nur einblenden wenn sie auch aktiv sein sollen 
  function PWGen_CheckAnsicht() {

    if (getID("PWGenOptions_Einstellungen_InputProfiEinstellungen").value == "true"){
      getID("PWGenOptions_ButtonAussehen").style.display = "inline-block";
      var y = document.querySelectorAll('tr.PWGen_Profioptionen');                        // Profi-Optionen aktiv
      for (var i = 0; i < y.length; i++) {
        y[i].style.display='table-row';
      };        
    }
    else {
      getID("PWGenOptions_ButtonAussehen").style.display = "none";
      var y = document.querySelectorAll('tr.PWGen_Profioptionen');                        // Profi-Optionen inaktiv
      for (var i = 0; i < y.length; i++) {
        y[i].style.display='none';
      };
    };                  

    if (getID("PWGenOptions_Einstellungen_InputMarkerAktiv").value == "true"){
      var y = document.querySelectorAll('tr.PWGen_Markeroptionen');                        // Marker aktiv
      for (var i = 0; i < y.length; i++) {
        y[i].style.display='table-row';
      };
      getID("MarkerMuster").setAttribute ("src", "../../icons/marker_" + getID("PWGenOptions_Einstellungen_InputMarkerFarbe").value + ".svg")        
    }
    else {
      var y = document.querySelectorAll('tr.PWGen_Markeroptionen');                        // Marker inaktiv
      for (var i = 0; i < y.length; i++) {
        y[i].style.display='none';
      };
    };                  

    if (getID("PWGenOptions_Einstellungen_InputMasterpasswort").value == "2"){
      var y = document.querySelectorAll('tr.PWGen_Masterpasswort_Vorgabe');                        // Master-Passwort speichern ja
      for (var i = 0; i < y.length; i++) {
        y[i].style.display='table-row';
      };        
    }
    else {
      var y = document.querySelectorAll('tr.PWGen_Masterpasswort_Vorgabe');                        // Master-Passwort speichern nein
      for (var i = 0; i < y.length; i++) {
        y[i].style.display='none';
      };
    };                  
  
  
  } 

  function setStatus(t) {
    getID(t).style.background = "lightgreen";
    setTimeout(() => getID(t).style.background = "", 700);    
  }

/*
function setStatus(statusText) {
    const status = document.getElementById("status");
    status.textContent = statusText;
    setTimeout(() => status.textContent = "", 1500);
}
*/